<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class PhoneNumber implements Rule
{
  protected $dialCode;

  // Optional: map of country dial codes to expected phone lengths
  protected $countryLengths = [
    '+93' => 9,      // Afghanistan
    '+355' => 9,     // Albania
    '+213' => 9,     // Algeria
    '+376' => 6,     // Andorra
    '+244' => 9,     // Angola
    '+1-268' => 7,   // Antigua and Barbuda
    '+54' => 10,     // Argentina
    '+374' => 8,     // Armenia
    '+61' => 9,      // Australia
    '+43' => 10,     // Austria
    '+994' => 9,     // Azerbaijan
    '+1-242' => 7,   // Bahamas
    '+973' => 8,     // Bahrain
    '+880' => 11,    // Bangladesh
    '+1-246' => 7,   // Barbados
    '+375' => 9,     // Belarus
    '+32' => 9,      // Belgium
    '+501' => 7,     // Belize
    '+229' => 8,     // Benin
    '+975' => 8,     // Bhutan
    '+591' => 8,     // Bolivia
    '+387' => 8,     // Bosnia and Herzegovina
    '+267' => 8,     // Botswana
    '+55' => 11,     // Brazil
    '+673' => 7,     // Brunei
    '+359' => 9,     // Bulgaria
    '+226' => 8,     // Burkina Faso
    '+257' => 8,     // Burundi
    '+238' => 7,     // Cabo Verde
    '+855' => 9,     // Cambodia
    '+237' => 9,     // Cameroon
    '+1' => 10,      // Canada
    '+236' => 8,     // Central African Republic
    '+235' => 8,     // Chad
    '+56' => 9,      // Chile
    '+86' => 13,     // China
    '+57' => 10,     // Colombia
    '+269' => 7,     // Comoros
    '+242' => 8,     // Congo (Republic)
    '+506' => 8,     // Costa Rica
    '+385' => 9,     // Croatia
    '+53' => 8,      // Cuba
    '+357' => 8,     // Cyprus
    '+420' => 9,     // Czech Republic
    '+45' => 8,      // Denmark
    '+253' => 7,     // Djibouti
    '+1-767' => 7,   // Dominica
    '+1-809' => 10,  // Dominican Republic
    '+670' => 7,     // East Timor
    '+593' => 9,     // Ecuador
    '+20' => 10,     // Egypt
    '+503' => 8,     // El Salvador
    '+240' => 9,     // Equatorial Guinea
    '+291' => 7,     // Eritrea
    '+372' => 8,     // Estonia
    '+268' => 8,     // Eswatini
    '+251' => 9,     // Ethiopia
    '+679' => 7,     // Fiji
    '+358' => 9,     // Finland
    '+33' => 9,      // France
    '+241' => 8,     // Gabon
    '+220' => 7,     // Gambia
    '+995' => 9,     // Georgia
    '+49' => 11,     // Germany
    '+233' => 9,     // Ghana
    '+30' => 10,     // Greece
    '+1-473' => 7,   // Grenada
    '+502' => 8,     // Guatemala
    '+224' => 9,     // Guinea
    '+245' => 8,     // Guinea-Bissau
    '+592' => 7,     // Guyana
    '+509' => 8,     // Haiti
    '+504' => 8,     // Honduras
    '+36' => 9,      // Hungary
    '+354' => 7,     // Iceland
    '+91' => 10,     // India
    '+62' => 10,     // Indonesia
    '+98' => 10,     // Iran
    '+964' => 9,     // Iraq
    '+353' => 9,     // Ireland
    '+972' => 9,     // Israel
    '+39' => 10,     // Italy
    '+225' => 8,     // Ivory Coast
    '+1-876' => 7,   // Jamaica
    '+81' => 10,     // Japan
    '+962' => 9,     // Jordan
    '+7' => 10,      // Kazakhstan / Russia
    '+254' => 10,    // Kenya
    '+686' => 7,     // Kiribati
    '+850' => 8,     // Korea (North)
    '+82' => 10,     // Korea (South)
    '+965' => 8,     // Kuwait
    '+996' => 9,     // Kyrgyzstan
    '+856' => 8,     // Laos
    '+371' => 8,     // Latvia
    '+961' => 8,     // Lebanon
    '+266' => 8,     // Lesotho
    '+231' => 8,     // Liberia
    '+218' => 9,     // Libya
    '+423' => 8,     // Liechtenstein
    '+370' => 8,     // Lithuania
    '+352' => 9,     // Luxembourg
    '+261' => 9,     // Madagascar
    '+265' => 9,     // Malawi
    '+60' => 10,     // Malaysia
    '+960' => 7,     // Maldives
    '+223' => 8,     // Mali
    '+356' => 8,     // Malta
    '+692' => 7,     // Marshall Islands
    '+222' => 8,     // Mauritania
    '+230' => 8,     // Mauritius
    '+52' => 10,     // Mexico
    '+691' => 7,     // Micronesia
    '+373' => 8,     // Moldova
    '+377' => 8,     // Monaco
    '+976' => 8,     // Mongolia
    '+382' => 8,     // Montenegro
    '+212' => 9,     // Morocco
    '+258' => 12,    // Mozambique
    '+95' => 9,      // Myanmar
    '+264' => 9,     // Namibia
    '+674' => 8,     // Nauru
    '+977' => 10,    // Nepal
    '+31' => 9,      // Netherlands
    '+64' => 9,      // New Zealand
    '+505' => 8,     // Nicaragua
    '+227' => 8,     // Niger
    '+234' => 10,    // Nigeria
    '+47' => 8,      // Norway
    '+968' => 8,     // Oman
    '+92' => 10,     // Pakistan
    '+680' => 7,     // Palau
    '+507' => 8,     // Panama
    '+675' => 8,     // Papua New Guinea
    '+595' => 9,     // Paraguay
    '+51' => 9,      // Peru
    '+63' => 10,     // Philippines
    '+48' => 9,      // Poland
    '+351' => 9,     // Portugal
    '+974' => 8,     // Qatar
    '+40' => 10,     // Romania
    '+250' => 9,     // Rwanda
    '+1-869' => 7,   // Saint Kitts and Nevis
    '+1-758' => 7,   // Saint Lucia
    '+1-784' => 7,   // Saint Vincent and the Grenadines
    '+685' => 7,     // Samoa
    '+378' => 9,     // San Marino
    '+239' => 7,     // São Tomé and Príncipe
    '+966' => 9,     // Saudi Arabia
    '+221' => 8,     // Senegal
    '+381' => 9,     // Serbia
    '+248' => 7,     // Seychelles
    '+232' => 8,     // Sierra Leone
    '+65' => 8,      // Singapore
    '+1-721' => 7,   // Sint Maarten
    '+421' => 9,     // Slovakia
    '+386' => 8,     // Slovenia
    '+677' => 7,     // Solomon Islands
    '+252' => 8,     // Somalia
    '+27' => 9,      // South Africa
    '+211' => 9,     // South Sudan
    '+34' => 9,      // Spain
    '+94' => 10,     // Sri Lanka
    '+249' => 9,     // Sudan
    '+597' => 7,     // Suriname
    '+46' => 9,      // Sweden
    '+41' => 9,      // Switzerland
    '+963' => 9,     // Syria
    '+886' => 10,    // Taiwan
    '+992' => 9,     // Tajikistan
    '+255' => 10,    // Tanzania
    '+66' => 9,      // Thailand
    '+228' => 8,     // Togo
    '+676' => 7,     // Tonga
    '+1-868' => 10,  // Trinidad and Tobago
    '+216' => 8,     // Tunisia
    '+90' => 10,     // Turkey
    '+993' => 8,     // Turkmenistan
    '+688' => 7,     // Tuvalu
    '+256' => 9,     // Uganda
    '+380' => 9,     // Ukraine
    '+971' => 9,     // United Arab Emirates
    '+44' => 10,     // United Kingdom
    '+1' => 10,      // USA
    '+598' => 8,     // Uruguay
    '+998' => 9,     // Uzbekistan
    '+678' => 7,     // Vanuatu
    '+39-347' => 10, // Vatican City
    '+58' => 10,     // Venezuela
    '+84' => 9,      // Vietnam
    '+681' => 6,     // Wallis and Futuna
    '+967' => 9,     // Yemen
    '+260' => 9,     // Zambia
    '+263' => 9,     // Zimbabwe
  ];



  public function __construct($dialCode)
  {
    $this->dialCode = $dialCode;
  }

  public function passes($attribute, $value)
  {
    // Remove non-digit characters except +
    $value = preg_replace('/[^\d]/', '', $value);

    // Validate dial code format
    if (!preg_match('/^\+\d{1,4}$/', $this->dialCode)) {
      return false;
    }

    // Check if we have a length defined for this dial code
    if (isset($this->countryLengths[$this->dialCode])) {
      return strlen($value) === $this->countryLengths[$this->dialCode];
    }

    // Default global validation: 4–17 digits
    return strlen($value) >= 4 && strlen($value) <= 17;
  }

  public function message()
  {
    return 'The :attribute is not a valid phone number for the selected country.';
  }
}
