<?php
namespace App\Repositories\Eloquent;
use App\Models\VehicleModel;
use App\Repositories\Contracts\VehicleBrandRepositoryInterface;
use App\Repositories\Contracts\VehicleCategoryRepositoryInterface;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\VehicleModelRepositoryInterface;
class VehicleModelRepository extends BaseRepository implements VehicleModelRepositoryInterface
{

  protected $vehicleModelRepository;
  protected $vehicleBrandRepository;
  protected $vehicleCategoryRepository;
  public function __construct(
    VehicleModel $vehicleModel,
    VehicleCategoryRepositoryInterface $vehicleCategoryRepository,
    VehicleBrandRepositoryInterface $vehicleBrandRepository
  ) {
    $this->vehicleCategoryRepository = $vehicleCategoryRepository;
    $this->vehicleBrandRepository = $vehicleBrandRepository;
    parent::__construct($vehicleModel);
  }

  public function allModels()
  {
    $parentCategories = $this->vehicleCategoryRepository->dropdown();
    $brands = $this->vehicleBrandRepository->dropdown();
    return [
      'categories' => $parentCategories,
      'brands' => $brands
    ];
  }

  public function dropdown()
  {
    return VehicleModel::where('status', 1)->orderBy('name')->get();
  }

  public function store(array $data)
  {
    return VehicleModel::create([
      'name' => $data['name'],
      'image' => $data['image'] ?? '',
      'vehicle_parent_id' => $data['vehicle_parent_id'],
      'vehicle_category_id' => $data['vehicle_category_id'],
      'vehicle_brand_id' => $data['vehicle_brand_id'],
      'status' => 1,
    ]);
  }

}
