<?php
namespace App\Repositories\Eloquent;
use App\Models\VehicleBrand;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\VehicleBrandRepositoryInterface;
class VehicleBrandRepository extends BaseRepository implements VehicleBrandRepositoryInterface
{
  public function __construct(VehicleBrand $vehicleBrandModel)
  {
    parent::__construct($vehicleBrandModel);
  }

  public function allBrands()
  {
    return VehicleBrand::orderBy('name')->get();
  }

  public function dropdown()
  {
    return VehicleBrand::where('status', 1)->orderBy('name')->get();
  }

  public function store(array $data)
  {
    return VehicleBrand::create([
      'name' => $data['name'],
      'image' => $data['image'] ?? '',
      'status' => 1,
    ]);
  }

}
