<?php

namespace App\Repositories\Eloquent;
use App\Models\Referral;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Helpers\Helpers;
use Carbon\Carbon;
use App\Repositories\BaseRepository;
use Illuminate\Support\Facades\Log;

use App\Repositories\Contracts\ReferralRepositoryInterface;
class ReferralRepository extends BaseRepository implements ReferralRepositoryInterface
{
  public function __construct(Referral $referralModel)
  {
    parent::__construct($referralModel);
  }

  public function allList($request)
  {
    $canDelete = Auth::user()->can('referral-delete');
    $canEdit = Auth::user()->can('referral-edit');
    $canCreate = Auth::user()->can('referral-create');
    $builder = Referral::with(['user', 'refer']);
    $prefix = Helpers::unreadCounts();
    $prefix = $prefix['prefix'];
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));
    // Clone for filters
    $query = clone $builder;
    if (!empty($request->input('search.value'))) {
      $search = $request->input('search.value');
      $query->where(function ($q) use ($search) {
        $q->whereHas('user', function ($q2) use ($search) {
          $q2->where('name', 'LIKE', "%{$search}%")
            ->orWhere('email', 'LIKE', "%{$search}%");
        })
          ->orWhereHas('refer', function ($q2) use ($search) {
            $q2->where('name', 'LIKE', "%{$search}%")
              ->orWhere('email', 'LIKE', "%{$search}%");
          });
      });
    }

    if (!is_null($request->input('status'))) {
      $query->where('status', (int) $request->input('status'));
    }
    if (!is_null($request->input('customer'))) {
      $query->where('user_id', (int) $request->input('customer'));
    }
    // 🎯 Filter by type
    if (!is_null($request->input('type'))) {
      $query->where('type', $request->input('type'));
    }
    // 📅 Date filter
    if (!empty($request->input('start_date')) && !empty($request->input('end_date'))) {
      $startDate = Carbon::parse($request->input('start_date'))->startOfDay();
      $endDate = Carbon::parse($request->input('end_date'))->endOfDay();
      $query->whereBetween('created_at', [$startDate, $endDate]);
    }
    return \DataTables::eloquent($query) // eager load relations
      ->addIndexColumn()
      ->addColumn('customer', fn($referral) => $referral->user?->name ?? '-')
      ->addColumn('email', fn($referral) => $referral->user?->email ?? '-')
      ->addColumn('user_type', fn($referral) => $referral->user?->user_type ?? '-')
      ->addColumn('avatar', function ($referral) {
        return $referral->user && $referral->user->profile_photo_path
          ? asset('storage/' . $referral->user->profile_photo_path)
          : '';
      })
      ->addColumn('refer', fn($referral) => $referral->refer?->name ?? '-')
      ->addColumn('r_email', fn($referral) => $referral->refer?->email ?? '-')
      ->addColumn('r_user_type', fn($referral) => $referral->refer?->user_type ?? '-')
      ->addColumn('r_avatar', function ($referral) {
        return $referral->refer && $referral->refer->profile_photo_path
          ? asset('storage/' . $referral->refer->profile_photo_path)
          : '';
      })
      ->addColumn('currency', fn($referral) => $referral->user?->currency ?? $currency)
      ->addColumn('edit', $canEdit)
      ->addColumn('delete', $canDelete)
      ->addColumn('create', $canCreate)
      ->addColumn('delete-url', fn($referral) => url($prefix . 'referrals/' . $referral->id))
      ->addColumn('status-url', fn() => url($prefix . 'referrals/changestatus'))
      ->with([
        'recordsTotal' => $builder->count()
      ])
      ->make(true);

  }


  public function store(Request $request, $Id = null): array
  {
    $data = [];
    return $data;
  }

}
