<?php
namespace App\Repositories\Eloquent;
use App\Models\ParcelCategory;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\ParcelCategoryRepositoryInterface;
class ParcelCategoryRepository extends BaseRepository implements ParcelCategoryRepositoryInterface
{
  public function __construct(ParcelCategory $parcelCategoryModel)
  {
    parent::__construct($parcelCategoryModel);
  }

  public function allCategories()
  {
    //remove  whereNull('parent_id') for multiple level categories
    return ParcelCategory::whereNull('parent_id')
      ->orderBy('name')->get();
  }
  function buildIndentedParcelCategoryList($categories, $prefix = '')
  {
    $list = [];
    foreach ($categories as $category) {
      $list[$category->id] = $prefix . $category->name;
      if ($category->children) {
        $list += $this->buildIndentedParcelCategoryList($category->children, $prefix . '— ');
      }
    }
    return $list;
  }

  public function dropdown()
  {
    return $this->buildIndentedParcelCategoryList(ParcelCategory::with('children')->whereNull('parent_id')->get());
  }

  public function store(array $data)
  {
    return ParcelCategory::create([
      'parent_id' => $data['parent_id'] ?? null,
      'name' => $data['name'],
      'description' => $data['description'] ?? '',
      'image' => $data['image'] ?? '',
      'status' => 1,
    ]);
  }

  public function subCategories($id)
  {
    return ParcelCategory::where('parent_id', $id)->get();
  }
}
