<?php
namespace App\Repositories\Eloquent;
use App\Models\Package;
use App\Helpers\Helpers;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\PackageRepositoryInterface;
class PackageRepository extends BaseRepository implements PackageRepositoryInterface
{
  public function __construct(Package $packageModel)
  {
    parent::__construct($packageModel);
  }
  public function allPackages()
  {
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));
    $packages = Package::query();
    return \DataTables::of($packages)->addIndexColumn()
      ->addColumn('duration', function ($row) {
        return $row->duration ? $row->duration->name . ' ' . $row->duration->weeks : '-';
      })
      ->addColumn('currency', $currency)
      ->make(true);

  }

  public function dropdown()
  {
    return Package::get();
  }

  public function store(array $data)
  {
    return Package::create($data);
  }

}
