<?php
namespace App\Repositories\Eloquent;
use App\Models\DeliveryCharge;
use Illuminate\Http\Request;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\DeliveryChargeRepositoryInterface;
class DeliveryChargeRepository extends BaseRepository implements DeliveryChargeRepositoryInterface
{
  public function __construct(DeliveryCharge $deliveryChargeModel)
  {
    parent::__construct($deliveryChargeModel);
  }
  public function getDeliveryCharges($countryId)
  {
    $deliveries = DeliveryCharge::where('country_id', $countryId)
      ->orderBy('id', 'asc')
      ->get();
    return $deliveries;
  }

  public function store(Request $request)
  {
    $countryId = $request->country_id;
    DeliveryCharge::where('country_id', $countryId)->delete();
    foreach ($request->input('group-a') as $row) {
      DeliveryCharge::create([
        'country_id' => $countryId,
        'from_km' => $row['from_km'],
        'to_km' => $row['to_km'],
        'amount' => $row['amount'],
      ]);
    }
  }


}
