<?php
namespace App\Repositories\Eloquent;
use App\Models\Banner;
use Carbon\Carbon;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\BannerRepositoryInterface;

class BannerRepository extends BaseRepository implements BannerRepositoryInterface
{
  public function __construct(Banner $bannerModel)
  {
    parent::__construct($bannerModel);
  }

  public function store(array $data)
  {
    // Parse date range if provided
    if (!empty($data['date'])) {
      if (str_contains($data['date'], ' to ')) {
        [$start, $end] = explode(' to ', $data['date']);
      } elseif (str_contains($data['date'], ' - ')) {
        [$start, $end] = explode(' - ', $data['date']);
      }
      if (!empty($start) && !empty($end)) {
        $data['start_date'] = Carbon::parse($start)->format('Y-m-d');
        $data['end_date'] = Carbon::parse($end)->format('Y-m-d');
      }
    }
    $data['user_id'] = auth()->id();
    return Banner::updateOrCreate(
      ['id' => $data['id'] ?? null],
      $data
    );
  }

  //Api's
  public function banners($type, $id)
  {
    return Banner::active()
      ->where('link', $type)
      ->where('record_id', $id)
      ->get();
  }

}
