<?php

namespace App\Repositories\Contracts;
use Illuminate\Http\Request;
interface ProductRepositoryInterface
{
  public function all(array $filters = []);
  public function allList(Request $request);
  public function toggleStatus(int $id, int $status);
  public function changeStock($id, $status);
  public function find(int $id);
  public function delete(int $id);
  public function getProductsByStore(Request $request);
  public function getProductsByCategory(Request $request);
  public function store(Request $request, $id);
  public function productList(Request $request, $storeId);
  public function productDetail($id);

}
