<?php

namespace App\Repositories\Contracts;
use Illuminate\Http\Request;
interface DriverRepositoryInterface
{
  public function all(array $filters = []);
  public function allList(Request $request);
  public function allMaps(Request $request);
  public function changeStatus($id, $status);
  public function find(int $id);
  public function store(Request $request, $id);
  public function register(Request $request, $id);
  public function dropdown();
  public function getNearestDrivers($latitude, $longitude, $limit, $type, $vehicleCategoryId);
  public function getVehicleTypes(Request $request);
  public function activeDrivers($type);
  public function toggleActiveStatus();
}
