<?php

namespace App\Providers;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Vite;
use Illuminate\Support\Facades\View;
use Helper;
use App\Repositories\Eloquent\ContactRepository;
use App\Repositories\Contracts\ContactRepositoryInterface;
use App\Repositories\Eloquent\FaqRepository;
use App\Repositories\Contracts\FaqRepositoryInterface;
use App\Repositories\Contracts\CategoryRepositoryInterface;
use App\Repositories\Eloquent\CategoryRepository;
use App\Repositories\Contracts\ParcelCategoryRepositoryInterface;
use App\Repositories\Eloquent\ParcelCategoryRepository;
use App\Repositories\Contracts\VehicleCategoryRepositoryInterface;
use App\Repositories\Eloquent\VehicleCategoryRepository;
use App\Repositories\Contracts\VehicleBrandRepositoryInterface;
use App\Repositories\Eloquent\VehicleBrandRepository;
use App\Repositories\Contracts\VehicleModelRepositoryInterface;
use App\Repositories\Eloquent\VehicleModelRepository;
use App\Repositories\Contracts\VehicleRepositoryInterface;
use App\Repositories\Eloquent\VehicleRepository;
use App\Repositories\Contracts\BannerRepositoryInterface;
use App\Repositories\Eloquent\BannerRepository;
use App\Repositories\Contracts\UserRepositoryInterface;
use App\Repositories\Eloquent\UserRepository;
use App\Repositories\Contracts\DriverRepositoryInterface;
use App\Repositories\Eloquent\DriverRepository;
use App\Repositories\Eloquent\RideRequestRepository;
use App\Repositories\Contracts\RideRequestRepositoryInterface;
use App\Repositories\Eloquent\RideRepository;
use App\Repositories\Contracts\RideRepositoryInterface;
use App\Repositories\Eloquent\CouponRepository;
use App\Repositories\Contracts\CouponRepositoryInterface;
use App\Repositories\Eloquent\StoreRepository;
use App\Repositories\Contracts\StoreRepositoryInterface;
use App\Repositories\Eloquent\ProductRepository;
use App\Repositories\Contracts\ProductRepositoryInterface;
use App\Repositories\Eloquent\OrderRepository;
use App\Repositories\Contracts\OrderRepositoryInterface;
use App\Repositories\Eloquent\WithdrawalRequestRepository;
use App\Repositories\Contracts\WithdrawalRequestRepositoryInterface;
use App\Repositories\Eloquent\TransactionRepository;
use App\Repositories\Contracts\TransactionRepositoryInterface;
use App\Repositories\Eloquent\PackageRepository;
use App\Repositories\Contracts\PackageRepositoryInterface;
use App\Repositories\Eloquent\ReviewRepository;
use App\Repositories\Contracts\ReviewRepositoryInterface;
use App\Repositories\Eloquent\SosAlertRepository;
use App\Repositories\Contracts\SosAlertRepositoryInterface;
use App\Repositories\Eloquent\ReferralRepository;
use App\Repositories\Contracts\ReferralRepositoryInterface;
use App\Repositories\Eloquent\CarRepository;
use App\Repositories\Contracts\CarRepositoryInterface;
use App\Repositories\Eloquent\CartRepository;
use App\Repositories\Contracts\CartRepositoryInterface;
use App\Repositories\Eloquent\InstallmentRepository;
use App\Repositories\Contracts\InstallmentRepositoryInterface;
use App\Repositories\Eloquent\RentalRepository;
use App\Repositories\Contracts\RentalRepositoryInterface;
use App\Repositories\Eloquent\DeliveryChargeRepository;
use App\Repositories\Contracts\DeliveryChargeRepositoryInterface;
use Laravel\Cashier\Cashier;
use Illuminate\Database\Eloquent\Relations\Relation;
use App\Models\User;
use App\Models\Driver;
use App\Models\Store;
use App\Models\Product;
use App\Models\Ride;
use App\Models\Order;
use App\Models\Transaction;
use App\Models\Package;
use App\Models\Vehicle;
use App\Models\WalletTransaction;
use App\Observers\ProductObserver;
use App\Observers\DriverObserver;
use App\Observers\OrderObserver;
use App\Observers\UserObserver;
use App\Observers\StoreObserver;
use App\Observers\RideObserver;
use App\Observers\TransactionObserver;
use App\Observers\VehicleObserver;
use Illuminate\Support\Facades\DB;
class AppServiceProvider extends ServiceProvider
{
  /**
   * Register any application services.
   */
  public function register(): void
  {
    $this->app->bind(ContactRepositoryInterface::class, ContactRepository::class);
    $this->app->bind(FaqRepositoryInterface::class, FaqRepository::class);
    $this->app->bind(CategoryRepositoryInterface::class, CategoryRepository::class);
    $this->app->bind(ParcelCategoryRepositoryInterface::class, ParcelCategoryRepository::class);
    $this->app->bind(VehicleCategoryRepositoryInterface::class, VehicleCategoryRepository::class);
    $this->app->bind(VehicleBrandRepositoryInterface::class, VehicleBrandRepository::class);
    $this->app->bind(VehicleModelRepositoryInterface::class, VehicleModelRepository::class);
    $this->app->bind(VehicleRepositoryInterface::class, VehicleRepository::class);
    $this->app->bind(BannerRepositoryInterface::class, BannerRepository::class);
    $this->app->bind(UserRepositoryInterface::class, UserRepository::class);
    $this->app->bind(DriverRepositoryInterface::class, DriverRepository::class);
    $this->app->bind(RideRequestRepositoryInterface::class, RideRequestRepository::class);
    $this->app->bind(RideRepositoryInterface::class, RideRepository::class);
    $this->app->bind(CouponRepositoryInterface::class, CouponRepository::class);
    $this->app->bind(StoreRepositoryInterface::class, StoreRepository::class);
    $this->app->bind(ProductRepositoryInterface::class, ProductRepository::class);
    $this->app->bind(OrderRepositoryInterface::class, OrderRepository::class);
    $this->app->bind(WithdrawalRequestRepositoryInterface::class, WithdrawalRequestRepository::class);
    $this->app->bind(TransactionRepositoryInterface::class, TransactionRepository::class);
    $this->app->bind(PackageRepositoryInterface::class, PackageRepository::class);
    $this->app->bind(ReviewRepositoryInterface::class, ReviewRepository::class);
    $this->app->bind(SosAlertRepositoryInterface::class, SosAlertRepository::class);
    $this->app->bind(ReferralRepositoryInterface::class, ReferralRepository::class);
    $this->app->bind(CarRepositoryInterface::class, CarRepository::class);
    $this->app->bind(CartRepositoryInterface::class, CartRepository::class);
    $this->app->bind(InstallmentRepositoryInterface::class, InstallmentRepository::class);
    $this->app->bind(RentalRepositoryInterface::class, RentalRepository::class);
    $this->app->bind(DeliveryChargeRepositoryInterface::class, DeliveryChargeRepository::class);
  }

  /**
   * Bootstrap any application services.
   */
  public function boot(): void
  {
    Vite::useStyleTagAttributes(function (?string $src, string $url, ?array $chunk, ?array $manifest) {
      if ($src !== null) {
        return [
          'class' => preg_match("/(resources\/assets\/vendor\/scss\/(rtl\/)?core)-?.*/i", $src) ? 'template-customizer-core-css' : (preg_match("/(resources\/assets\/vendor\/scss\/(rtl\/)?theme)-?.*/i", $src) ? 'template-customizer-theme-css' : '')
        ];
      }
      return [];
    });

    View::composer('*', function ($view) {
      if (auth()->check()) {
        $view->with('adminConfigData', Helper::unreadCounts());
      }
    });
    Cashier::useCustomerModel(User::class);

    Relation::morphMap([
      'driver' => Driver::class,
      'store' => Store::class,
      'ride' => Ride::class,
      'order' => Order::class,
      'product' => Product::class,
      'wallet' => WalletTransaction::class,
      'package' => Package::class,
      'settlement' => WalletTransaction::class,
    ]);

    Product::observe(ProductObserver::class);
    Driver::observe(DriverObserver::class);
    Order::observe(OrderObserver::class);
    Ride::observe(RideObserver::class);
    Store::observe(StoreObserver::class);
    User::observe(UserObserver::class);
    Transaction::observe(TransactionObserver::class);
    Vehicle::observe(VehicleObserver::class);

    DB::macro('ordersWithoutPendingOnline', function () {
      return DB::table('orders')->where(function ($q) {
        $q->where('payment_status', '!=', 'Pending')
          ->orWhere('payment_type', '!=', 'Online');
      });
    });

    if (config('app.env') !== 'local') {
      URL::forceScheme('https');
    }
  }
}
