<?php
namespace App\Observers;
use App\Helpers\Helpers;
use App\Models\Vehicle;

class VehicleObserver
{
  public function updating(Vehicle $vehicle)
  {
    // List of vehicle fields that trigger unverify
    $fieldsToCheck = [
      'vehicle_category_id',
      'vehicle_parent_category_id',
      'vehicle_brand_id',
      'vehicle_model_id',
      'vehicle_color',
      'vehicle_year',
      'registration_number',
      'license_plate'
    ];

    if ($vehicle->isDirty($fieldsToCheck)) {
      $driver = $vehicle->driver;
      if ($driver) {
        $driver->is_verified = 0;
        $driver->save();
        $url = 'drivers/' . $driver->id;
        $message = 'Vehicle Details of driver was updated. Please verify the driver.';
        Helpers::adminNotification("Driver Details Updated", 'App\Notifications\Driver', $message, $driver->id, $url, $driver->id);
      }
    }
  }
}
