<?php

namespace App\Observers;

use App\Models\Transaction;
class TransactionObserver
{
  /**
   * Handle events after a transaction is created or updated.
   */
  public function saved(Transaction $transaction)
  {
    cacheForget('dashboard_transactions', ['dashboard']);
    cacheForget("dropdown_transactions_user", ['dropdown']);
  }

  /**
   * Handle events after a transaction is deleted.
   */
  public function deleted(Transaction $transaction)
  {
    cacheForget('dashboard_transactions', ['dashboard']);
  }
}
