<?php
namespace App\Observers;
use App\Services\ReferralService;
use App\Models\Ride;
class RideObserver
{
  protected $referralService;

  public function __construct(ReferralService $referralService)
  {
    $this->referralService = $referralService;
  }

  public function updated(Ride $ride)
  {
    if ($ride->wasChanged('status') && $ride->status === 'Completed' && empty($ride->order_id)) {
      // Rider (customer) referral check
      if ($ride->user) {
        $this->referralService->giveReferralReward($ride->user);
      }
      // Driver referral check
      if ($ride->driver && $ride->driver->user) {
        $this->referralService->giveReferralReward($ride->driver->user);
      }
    }
    cacheForget('dashboard_ongoing_rides', ['dashboard']);
    cacheForget('rides_dashboard_data', ['dashboard']);
    cacheForget('earning_reports', ['dashboard']);
    cacheForget('sales_last_six_months', ['dashboard']);
  }

  public function created(Ride $ride)
  {
    cacheForget('dashboard_ongoing_rides', ['dashboard']);
    cacheForget('rides_dashboard_data', ['dashboard']);
    cacheForget('earning_reports', ['dashboard']);
    cacheForget('sales_last_six_months', ['dashboard']);
    cacheForget("dropdown_rides_user", ['dropdown']);
    cacheForget("dropdown_rides_driver", ['dropdown']);
  }
}
