<?php
namespace App\Observers;

use App\Models\Product;
use App\Models\Store;

class ProductObserver
{
  public function saved(Product $product)
  {
    $this->updateStoreVegStatus($product->store_id);
  }

  public function deleted(Product $product)
  {
    $this->updateStoreVegStatus($product->store_id);
  }

  protected function updateStoreVegStatus($storeId)
  {
    if (!$storeId)
      return;
    $isNonVeg = Product::where('store_id', $storeId)
      ->where('is_non_veg', 1)
      ->exists();
    Store::where('id', $storeId)->update(['is_non_veg' => $isNonVeg ? 1 : 0]);
  }
}
