<?php
namespace App\Observers;
use App\Services\ReferralService;
use App\Models\Order;
class OrderObserver
{
  protected $referralService;

  public function __construct(ReferralService $referralService)
  {
    $this->referralService = $referralService;
  }

  public function updated(Order $order)
  {
    if ($order->wasChanged('status') && $order->status === 'Delivered') {
      // Reward the customer (order->user)
      $this->referralService->giveReferralReward($order->user);
      // Reward the driver (order->ride->driver)
      if ($order->ride && $order->ride->driver->user) {
        $this->referralService->giveReferralReward($order->ride->driver->user);
      }
    }
    cacheForget('orders_last_week', ['dashboard']);
    cacheForget('sales_last_year', ['dashboard']);
    cacheForget('earning_reports', ['dashboard']);
    cacheForget('sales_last_six_months', ['dashboard']);
  }
  public function created(Order $ride)
  {
    cacheForget('orders_last_week', ['dashboard']);
    cacheForget('sales_last_year', ['dashboard']);
    cacheForget('earning_reports', ['dashboard']);
    cacheForget('sales_last_six_months', ['dashboard']);
    cacheForget("dropdown_orders_user", ['dropdown']);
  }
}
