<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
class Subscription extends BaseModel
{
  use HasFactory;
  protected $fillable = [
    'user_id',
    'name',
    'package_id',
    'amount',
    'status',
    'stripe_subscription_id',
    'next_billing_date',
    'canceled_at',
  ];
  public function user()
  {
    return $this->belongsTo(User::class);
  }

  public function package()
  {
    return $this->belongsTo(Package::class);
  }


}
