<?php
namespace App\Models;
class Review extends BaseModel
{
  protected $fillable = ['reviewable_id', 'reviewable_type', 'user_id', 'driver_id', 'rating', 'comment', 'status'];
  public function reviewable()
  {
    return $this->morphTo();
  }
  public function user()
  {
    return $this->belongsTo(User::class)->withTrashed();
  }
  public function driver()
  {
    return $this->belongsTo(Driver::class);
  }

}
