<?php

namespace App\Models;
class Rental extends BaseModel
{
  protected $fillable = ['car_id', 'driver_id', 'order_type', 'total_amount', 'down_payment', 'pending_amount', 'no_of_installments', 'installment_amount', 'security_amount', 'start_date', 'due_date', 'status'];
  public function car()
  {
    return $this->belongsTo(Car::class);
  }

  public function driver()
  {
    return $this->belongsTo(Driver::class);
  }

  public function installments()
  {
    return $this->hasMany(Installment::class);
  }
}
