<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Builder;
class Order extends BaseModel
{
  protected $fillable = ['user_id', 'order_id', 'store_id', 'address', 'latitude', 'longitude', 'subtotal', 'grand_total', 'tax', 'discount', 'coupon_id', 'platform_commission', 'shipping', 'currency', 'rating', 'delivered_at', 'payment_status', 'payment_type', 'prescriptions', 'status'];

  protected static function booted()
  {
    static::addGlobalScope('excludePendingOnline', function (Builder $builder) {
      $builder->where(function ($q) {
        $q->where('payment_status', '!=', 'Pending')
          ->orWhere('payment_type', '!=', 'Online');
      });
    });
  }
  public function review()
  {
    return $this->morphOne(Review::class, 'reviewable');
  }
  public function reviews()
  {
    return $this->morphMany(Review::class, 'reviewable');
  }
  public function user()
  {
    return $this->belongsTo(User::class)->withTrashed();
  }
  public function store()
  {
    return $this->belongsTo(Store::class);
  }
  public function items()
  {
    return $this->hasMany(OrderItem::class);
  }
  public function ride()
  {
    return $this->hasOne(Ride::class);
  }
  public function transaction()
  {
    return $this->morphOne(Transaction::class, 'transactionable');
  }

  public function statusLogs()
  {
    return $this->morphMany(StatusLog::class, 'trackable');
  }


}
