<?php

namespace App\Models;
use App\Enums\CouponType;
use App\Traits\HasEnumsTrait;
class Coupon extends BaseModel
{
  use HasEnumsTrait;
  protected $fillable = ['type', 'code', 'details', 'discount', 'discount_type', 'start_date', 'end_date', 'status'];
  protected array $enums = [
    'type' => CouponType::class,
  ];
  public function usage()
  {
    return $this->hasMany(CouponUsage::class)->orderBy('id', 'desc');
  }
}
