<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
class Category extends BaseModel
{
  use HasFactory, SoftDeletes; // ✅ Add SoftDeletes

  protected $fillable = ['parent_id', 'name', 'description', 'image', 'status', 'prescriptions', 'diet', 'tax'];
  protected $appends = ['parent_name', 'delete_url', 'status_url', 'is_prescrible', 'is_diet'];

  public function parent()
  {
    return $this->belongsTo(Category::class, 'parent_id');
  }

  public function children()
  {
    return $this->hasMany(Category::class, 'parent_id');
  }

  // Recursive children
  public function childrenRecursive()
  {
    return $this->children()->with('childrenRecursive');
  }

  public function getParentNameAttribute()
  {
    return $this->parent ? $this->parent->name : '';
  }
  public function getIsPrescribleAttribute()
  {
    return $this->parent ? $this->parent->prescriptions : 0;
  }
  public function getIsDietAttribute()
  {
    return $this->parent ? $this->parent->diet : 0;
  }

  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/categories/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/categories/changestatus");
  }

}
