<?php

namespace App\Models;
use App\Enums\BannerLinkType;
use App\Traits\HasEnumsTrait;
class Banner extends BaseModel
{
  use HasEnumsTrait;
  protected $fillable = ['record_id', 'name', 'image', 'description', 'link', 'link_url', 'start_date', 'end_date', 'status', 'user_id',];
  protected $appends = ['delete_url', 'status_url'];
  protected array $enums = [
    'status' => BannerLinkType::class,
  ];
  // Banner.php
  public function scopeActive($query)
  {
    return $query->where('status', 1)
      ->where(function ($q) {
        $q->whereNull('start_date')
          ->orWhere('start_date', '<=', now());
      })
      ->where(function ($q) {
        $q->whereNull('end_date')
          ->orWhere('end_date', '>=', now());
      });
  }


  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/banners/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/banners/changestatus");
  }
}
