<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvoiceEmail extends Mailable
{
  use Queueable, SerializesModels;

  public $data, $file;

  /**
   * Create a new message instance.
   */
  public function __construct($data, $file)
  {
    $this->data = $data;
    $this->file = $file;
  }

  /**
   * Build the message.
   */

  public function build()
  {
    return $this->subject($this->data['subject'])
      ->view('emails.invoiceEmail')
      ->with('data', $this->data)
      ->attach(
        $this->file->getRealPath(),
        [
          'as' => $this->file->getClientOriginalName(),
          'mime' => 'application/pdf',
        ]
      );
  }
}
