<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EmailOtpMail extends Mailable
{
  use Queueable, SerializesModels;

  public string $otp;

  public function __construct(string $otp)
  {
    $this->otp = $otp;
  }

  public function build()
  {
    return $this->subject('Your Email Verification Code')
      ->view('emails.email_otp')
      ->with([
        'otp' => $this->otp,
      ]);
  }
}
