<?php

namespace App\Listeners;
use App\Models\User;
use Musonza\Chat\Eventing\MessageWasSent;
use Musonza\Chat\Models\MessageNotification;
use App\Events\NewChatMessage;
use App\Helpers\Helpers;

class SendPushNotificationListener
{
  /**
   * Create the event listener.
   */
  public function __construct()
  {
    //
  }

  /**
   * Handle the event.
   */
  public function handle(MessageWasSent $event): void
  {
    $message = $event->message;

    $conversationId = $message->conversation_id;
    $senderId = $message->sender->id;

    // Load conversation participants (if you need them)
    $conversation = $message->conversation()->with('participants')->first();
    $receiverIds = $conversation
      ? $conversation->participants->where('id', '!=', $senderId)->pluck('id')->toArray()
      : [];

    $unreadCountsTotal = $unreadCounts = [];
    foreach ($receiverIds as $receiverUserId) {
      $unreadCountsTotal[$receiverUserId] = MessageNotification::
        //where('conversation_id', $conversation->id)->
        where('is_seen', 0)
        ->where('is_sender', 0)
        ->where('messageable_id', $receiverUserId)
        ->count() + 1;
      $unreadCounts[$receiverUserId] = MessageNotification::
        where('conversation_id', $conversation->id)
        ->where('is_seen', 0)
        ->where('is_sender', 0)
        ->where('messageable_id', $receiverUserId)
        ->count() + 1;
    }

    $payload = [
      'conversation_id' => $conversation->id,
      'message_id' => $message->id,
      'sender_id' => $senderId,
      'receiver_ids' => $receiverIds,
      'body' => $message->body,
      'created_at' => $message->created_at->toIso8601String(),
      'unread_count_total' => $unreadCountsTotal,
      'unread_count' => $unreadCounts,
    ];
    $tokens = User::whereIn('id', $receiverIds)->whereNotNull('fcm_token')->pluck('fcm_token')->toArray();
    // 🔔 Push Notification (FCM)
    if (!empty($tokens)) {
      Helpers::fcm_notifications('New Message', $message->body, $tokens, ['type' => 'chats', 'type_id' => $conversation->id]);
    }
    // 🔌 WebSocket broadcast
    broadcast(new NewChatMessage($payload, $receiverIds))->toOthers();
  }
}
