<?php
namespace App\Jobs;
use App\Services\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendSosSms implements ShouldQueue
{
  use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

  protected $phone;
  protected $message;

  /**
   * Create a new job instance.
   */
  public function __construct($phone, $message)
  {
    $this->phone = $phone;
    $this->message = $message;
  }

  /**
   * Execute the job.
   */
  public function handle()
  {
    SmsService::send($this->phone, $this->message);
  }
}
