<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class UserCollection extends ResourceCollection
{
  public function toArray($request)
  {
    return [
      'data' => $this->collection->map(function ($data) {
        return [
          'id' => (integer) $data->id,
          'name' => $data->name,
          'user_type' => $data->user_type,
          'email' => $data->email,
          'phone' => $data->dial_code . ' ' . $data->phone,
          'avatar' => empty($data->profile_photo_path) ? asset('assets/img/placeholder.jpg') : asset('storage/') . $data->profile_photo_path,
          'fcm_token' => $data->fcm_token,
          'last_seen' => $data->last_seen,
          'is_verified' => $data->is_verified == 1,
        ];
      })
    ];
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
