<?php

namespace App\Http\Resources;
use App\Helpers\Helpers;
use Illuminate\Http\Resources\Json\ResourceCollection;

class RideCollection extends ResourceCollection
{
  public function toArray($request)
  {
    return [
      'data' => $this->collection->map(function ($data) {
        return [
          'id' => (int) $data->id,
          'rideID' => $data->ride_id ?? '',
          'pickup_location' => $data->pickup_location ?? '',
          'drop_location' => $data->drop_location ?? '',
          'trip_distance' => $data->trip_distance . ' Km' ?? '',
          'trip_time' => $data->trip_time . ' Minutes' ?? '',
          'fare' => $data->fare ?? '',
          'currency' => $data->currency,
          'driver' => !empty($data['driver'])
            ? [
              'id' => $data['driver']->user?->id ?? null,
              'name' => $data['driver']->user?->name ?? '',
              'image' => $data['driver']->user?->profile_photo_url ?? '',
              'rides_count' => $data['driver']->rides_count ?? 0,
              'rating' => number_format($data['driver']->rating ?? 0, 1),
              'rating_count' => $data['driver']->rating_count ?? 0,
            ]
            : (object) [],
          'user' => !empty($data['user'])
            ? [
              'id' => $data['user']->id,
              'user_name' => $data['user']->name,
              'user_phone' => $data['user']->dial_code . $data['user']->phone,
            ]
            : (object) [],
          ...($data->type === 'Parcel'
            ? [
              'sender_name' => $data->sender_name,
              'receiver_name' => $data->receiver_name,
              'receiver_phone' => $data->receiver_phone,
              'parcel_category_id' => $data->parcel_category_id,
              'package_details' => $data->package_details,
            ]
            : []),
          ...($data->type === 'Delivery'
            ? [
              'order_id' => $data->order_id,
              'orderID' => $data->order?->order_id,
              'payment_type' => $data->order?->payment_type,
              'payment_status' => $data->order?->payment_status,
              ...($data->order?->payment_type != 'Online'
                ? [
                  'grand_total' => $data->order?->grand_total,
                ]
                : []),
              'latitude' => (float) $data->order?->latitude,
              'longitude' => (float) $data->order?->longitude,
              'user_name_in_order' => $data->order?->address ? json_decode($data->order?->address)?->name ?? '' : '',
              'address' => $data->order?->address ? json_decode($data->order?->address)?->address ?? '' : '',
              'store_name' => $data->order?->store?->user?->name,
              'store_phone' => $data->order?->store?->user?->dial_code . $data->order?->store?->user?->phone,
              'store_address' => $data->order?->store?->address,
              'store_image' => $data->order?->store?->user?->profile_image_path ? asset('storage/' . $data->order?->store?->user?->profile_image_path) : asset('assets/img/placeholder.jpg'),
            ]
            : []),
          'created_at' => date('d M Y h:i a', strtotime($data->created_at)),
          'status' => $data->status ?? 'Pending',
          'status_label' => Helpers::getStatusLabel($data->status, $data->type),
          'type' => $data->type,

        ];
      })
    ];
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
