<?php
namespace App\Http\Resources;
use Illuminate\Support\Str;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Helpers\Helpers;
use App\Models\Cart;

class ProductResource extends JsonResource
{
  public function toArray($request)
  {
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));
    $data = $this;
    $cartQuantity = 0;
    if (auth()->check()) {
      $cartItem = Cart::where('user_id', auth()->id())->where('product_id', $data->id)->first();
      if ($cartItem) {
        $cartQuantity = $cartItem->quantity;
      }
    }
    return [
      'id' => (integer) $data->id,
      'title' => $data->title ?? '',
      'sku' => $data->sku,
      'description' => Str::words(strip_tags($data->description), 10, '...'),
      'rating' => $data->rating,
      'strike_price' => $data->price,
      'price' => $data->discounted_price ?? $data->price,
      'currency' => $data->currency ?? $currency,
      'is_non_veg' => $data->is_non_veg ?? false,
      'in_stock' => $data->in_stock ?? false,
      'show_diet_type' => $data->show_diet_type,
      'image' => $data->images[0]->file ? asset('storage/' . $data->images[0]->file) : asset('assets/img/placeholder.jpg'),
      'rating_count' => Helpers::formatNumberShort($data->rating_count),
      'is_favorite' => $data->is_favorite ?? false,
      'images' => $this->images($data->images),
      'cart_quantity' => $cartQuantity,
    ];
  }

  private function images($images)
  {
    if (empty($images) || count($images) === 0) {
      return [
        [
          'file' => asset('assets/img/placeholder.jpg'),
        ]
      ];
    }
    return collect($images)->map(function ($img) {
      return [
        'file' => $img->file ? asset('storage/' . $img->file) : asset('assets/img/placeholder.jpg'),
      ];
    })->toArray();
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }


}
