<?php
namespace App\Http\Resources;
use Illuminate\Http\Resources\Json\ResourceCollection;

class DriverCollection extends ResourceCollection
{
  public function toArray($request)
  {
    return [
      'data' => $this->collection->map(function ($data) {
        return [
          'id' => $data->user_id,
          //'driver_id' => $data->id,
          'name' => $data->user?->name,
          'phone' => $data->user?->dial_code . ' ' . $data->user?->phone,
          'fcm_token' => $data->user?->fcm_token,
          'type' => $data->type,
          'last_seen' => $data->user?->last_seen,
          'has_ride' => (int) $data->has_ride == 1,
          'is_verified' => $data->user?->is_verified == 1,
          'is_active' => (int) $data->is_active == 1,
          'latitude' => (float) $data->latitude,
          'longitude' => (float) $data->longitude,
          'avatar' => empty($data->profile_photo_path) ? asset('assets/img/default.png') : asset('storage/') . $data->profile_photo_path,
          'distance' => number_format((float) $data->distance, 2, '.', ''), // always 2 decimals
          'range' => 'Km',
        ];
      })
    ];
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
