<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class CategoryCollection extends ResourceCollection
{
  protected $addParcel;
  public function __construct($resource, $addParcel = false)
  {
    parent::__construct($resource);
    $this->addParcel = $addParcel;
  }
  public function toArray($request)
  {
    $categories = $this->collection->map(function ($data) {
      return [
        'id' => (integer) $data->id,
        'name' => $data->name,
        'image' => $data->image ? asset('storage/' . $data->image) : asset('assets/img/placeholder.jpg'),
        ...($data->parent_id > 0
          ? [
            'prescriptions' => $data->prescriptions,
          ]
          : []),
        'special_category' => false,
      ];
    });
    // Add static category at last
    if ($this->addParcel) {
      $categories->push([
        'id' => 0, // some unique static ID
        'name' => 'Parcel',
        'image' => asset('assets/img/parcel.png'),
        'special_category' => true,
      ]);
    }

    return ['data' => $categories];

  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
