<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class BannerCollection extends ResourceCollection
{
  public function toArray($request)
  {
    return [
      'data' => $this->collection->map(function ($data) {
        return [
          'id' => (integer) $data->id,
          'name' => $data->name,
          'description' => $data->description,
          'link' => $data->link,
          'external_link' => $data->link == 'external_link' ? true : false,
          'link_url' => $data->link_url,
          'internal_link_id' => $record_id ?? '',
          'image' => $data->image ? asset('storage/' . $data->image) : asset('assets/img/placeholder.jpg'),

        ];
      })
    ];
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
