<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class VehicleBrandRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    $brandId = $this->route('vehicle_brand') ?? $this->route('id');

    return [
      'name' => [
        'required',
        'unique:vehicle_brands,name,' . ($brandId ?? 'NULL') . ',id',
      ],
      'image' => 'nullable|mimes:jpeg,png,jpg,webp',
      'status' => ['nullable'],
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
