<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
use App\Rules\PhoneNumber;
class UserRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $userId = $this->input('id');
    //$this->route('user') ?? $this->route('id');
    return [
      'name' => 'required|min:3',
      'email' => [
        'required',
        'unique:users,email,' . ($userId ?? 'NULL') . ',id',
      ],
      'phone' => [
        'required',
        'min:4',
        'max:17',
        new PhoneNumber($this->input('dial_code')),
        'unique:users,phone,' . ($userId ?? 'NULL') . ',id',
      ],
      'dial_code' => 'required',
      'dial_code_iso' => 'required',
      'address' => 'nullable',
      'referral_code' => 'nullable|exists:users,referral_code',
      'password' => $userId ? 'nullable|min:6' : 'required|min:6',
      'user_type' => 'required',
      'ride_type' => 'required_if:user_type,Driver',
      /* 'email_otp' => 'required|digits:6',
      'firebase_verification_id' => 'required',
      'firebase_otp' => 'required|digits_between:4,6', */
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }


  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
