<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
use App\Rules\PhoneNumber;
class StoreRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $userId = $this->input('user_id');
    //$this->route('user') ?? $this->route('id');
    return [
      'name' => 'required|string|min:3',
      'email' => [
        'required',
        'unique:users,email,' . ($userId ?? 'NULL') . ',id',
      ],
      'phone' => [
        'required',
        'min:4',
        'max:17',
        new PhoneNumber($this->input('dial_code')),
        'unique:users,phone,' . ($userId ?? 'NULL') . ',id',
      ],
      'password' => $userId ? 'nullable|min:6' : 'required|confirmed|min:6',
      'store_image' => ($userId ? 'nullable' : 'required') . '|image',

      // details
      'contact_person_phone' => [
        'required',
        'min:4',
        'max:17',
        new PhoneNumber($this->input('dial_code_contact')),
      ],
      'contact_person_name' => 'required',
      'delivery_time' => 'required|int',
      'service_tax' => auth()->user()->user_type == 'Admin' ? 'required|int' : 'nullable|int',
      'commission_charge' => auth()->user()->user_type == 'Admin' ? 'required|int' : 'nullable|int',
      'website' => 'nullable',
      'description' => 'required|string',

      // Address
      'address' => 'required|string',
      'city' => 'required|string',
      'state' => 'required|string',
      'country' => 'required|string',
      'postcode' => 'required|string',
      'landmark' => 'nullable',
      'bank_details' => 'nullable',

      // Documents
      'categories.*' => 'required',
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
