<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class StoreNotificationRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true;
  }

  public function rules(): array
  {
    return [
      'user_id' => 'required',
      'title' => 'required',
      'image' => 'required|mimes:jpeg,png,jpg,webp',
    ];
  }
  public function messages(): array
  {
    return [
    ];
  }
  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
