<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class SosContactRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    return [
      'contacts' => 'required|array|max:3',          // main array, max 3 items
      'contacts.*.name' => 'required|string|max:191', // each contact must have name
      'contacts.*.phone' => 'required|string|max:20', // each contact must have phone
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
