<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class RideRequestRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $userId = $this->input('user_id');
    //$this->route('user') ?? $this->route('id');
    return [
      'pickup_location' => 'required',
      'drop_location' => 'required',
      'pickup_lat' => 'required',
      'pickup_lng' => 'required',
      'drop_lat' => 'required',
      'drop_lng' => 'required',
      'estimate_fare' => 'required',
      'type' => 'required|string|in:Ride,Parcel,Delivery',

      'sender_name' => 'required_if:type,Parcel|string|max:255',
      'receiver_name' => 'required_if:type,Parcel|string|max:255',
      'receiver_phone' => 'required_if:type,Parcel|string|max:20',
      'parcel_category_id' => 'required_if:type,Parcel|exists:parcel_categories,id',
      'package_details' => 'nullable',
      'order_id' => 'required_if:type,Delivery|exists:orders,id',


    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
