<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class ReviewRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $this->route('review') ?? $this->route('id');
    return [
      'rating' => 'required|numeric|min:1|max:5',
      'comment' => 'nullable|string|max:1000',
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
