<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class RentalRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $this->route('rental') ?? $this->route('id');
    return [
      'car_id' => 'required',
      'driver_id' => 'required',
      'order_type' => 'required',
      'total_amount' => 'required',
      'down_payment' => 'required',
      'pending_amount' => 'nullable',
      'no_of_installments' => 'required',
      'installment_amount' => 'required',
      'security_amount' => 'nullable',
      'start_date' => 'nullable',
      'due_date' => 'nullable',
      'status' => 'nullable',
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }

}
