<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class PriceRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    return [
      'vehicle_category_id' => 'required|exists:vehicle_categories,id',
      'prices' => 'required|array|min:1',
      'prices.*.country_id' => 'required|exists:countries,id',
      'prices.*.base_fare' => 'nullable|numeric|min:0',
      'prices.*.per_km_rate' => 'nullable|numeric|min:0',
      'prices.*.per_minute_price' => 'nullable|numeric|min:0',
      'prices.*.per_minute_waiting_price' => 'nullable|numeric|min:0',
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
