<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
use App\Rules\PhoneNumber;
class PhoneEmailRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $userId = $this->input('id');
    //$this->route('user') ?? $this->route('id');
    return [
      'email' => [
        'nullable',
        'required_without:phone',
        'unique:users,email,' . ($userId ?? 'NULL') . ',id',
      ],
      'phone' => [
        'nullable',
        'required_without:email',
        'min:4',
        'max:17',
        new PhoneNumber($this->input('dial_code')),
        'unique:users,phone,' . ($userId ?? 'NULL') . ',id',
      ],
      'dial_code' => 'required',
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }


  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
