<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class ParcelCategoryRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    $categoryId = $this->route('parcel_category') ?? $this->route('id');

    return [
      'name' => [
        'required',
        'unique:parcel_categories,name,' . ($categoryId ?? 'NULL') . ',id',
      ],
      'image' => 'nullable|mimes:jpeg,png,jpg,webp',
      'description' => ['nullable'],
      'parent_id' => [
        'nullable',
        'different:' . ($categoryId ?? 'id'), // Laravel built-in validator
        function ($attribute, $value, $fail) use ($categoryId) {
          if ($value && $categoryId && (int) $value === (int) $categoryId) {
            $fail('A category cannot be its own parent.');
          }
        },
      ],
      'status' => ['nullable'],
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
