<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class FaqRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    // Get the FAQ ID from route. Adjust 'faq' if your route model binding uses a different name
    $faqId = $this->route('faq') ?? $this->route('id');

    return [
      'question' => [
        'required',
        'unique:faqs,question,' . ($faqId ?? 'NULL') . ',id',
      ],
      'answer' => ['required'],
      'type' => ['nullable'],
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
