<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class DeliveryChargeRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {

    return [
      'country_id' => 'required|integer',
      'group-a' => 'required|array',
      'group-a.*.from_km' => 'required|numeric|min:0',
      'group-a.*.to_km' => 'required|numeric|gt:group-a.*.from_km',
      'group-a.*.amount' => 'required|numeric|min:0',
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
