<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use App\Traits\ApiResponseTrait;
class ChangePictureRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize()
  {
    return true;
  }

  public function rules()
  {

    $rules = [
      'image' => 'required|mimes:jpeg,png,jpg,webp',
    ];
    return $rules;
  }


  public function messages()
  {
    return [
      '*.required' => 'The :attribute field is required.',
      '*.required_if' => 'The :attribute field is required when :other is :value.',
      '*.email' => 'The :attribute must be a valid email address.',
      '*.unique' => 'The :attribute has already been taken.',
      '*.confirmed' => 'The :attribute confirmation does not match.',
    ];
  }

  public function attributes()
  {
    return [
      'image' => 'Profile Image',
    ];
  }


  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
