<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class BannerRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    $bannerId = $this->route('banner') ?? $this->route('id');

    return [
      'name' => ['required', 'unique:banners,name,' . ($bannerId ?? 'NULL') . ',id'],
      'image' => $bannerId
        ? ['sometimes', 'nullable', 'mimes:jpeg,png,jpg,webp']
        : ['required', 'mimes:jpeg,png,jpg,webp'],
      'link' => ['nullable', 'in:external_link,store,product,category'],
      'link_url' => ['nullable', 'url', 'required_if:link,external_link'],
      'store' => ['nullable', 'exists:stores,id'],
      'product' => ['nullable', 'exists:products,id'],
      'date' => ['nullable'],
      'description' => ['nullable', 'string'],
      'main_category' => ['nullable', 'exists:categories,id'],
      'status' => ['nullable', 'boolean'],
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
