<?php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;
class EnsureEmailIsVerified
{

  /**
   * Handle an incoming request.
   *
   * @param  \Illuminate\Http\Request  $request
   * @param  \Closure  $next
   * @param  string|null  $guard
   * @return mixed
   */
  public function handle(Request $request, Closure $next): mixed
  {
    $response = $next($request);
    // $request->user() may also work
    if (
      auth()->check() &&
      (auth()->user() instanceof MustVerifyEmail &&
        !auth()->user()->hasVerifiedEmail())
    ) {
      auth()->logout();
      return response()->json([
        'message' => 'You need to confirm your account. We have sent you an activation link to your email.'
      ], 422);
    }
    return $response;

  }
}
