<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Repositories\Contracts\VehicleRepositoryInterface;
use App\Traits\JsonResponseTrait;
use Illuminate\Http\Request;
class VehicleController extends Controller
{
  use JsonResponseTrait;

  protected $vehicleRepository;

  public function __construct(VehicleRepositoryInterface $vehicleRepository)
  {
    $this->middleware('permission:vehicle-list|vehicle-create|vehicle-edit|vehicle-delete', ['only' => ['index', 'show', 'vehicleListAll']]);
    $this->middleware('permission:vehicle-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:vehicle-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:vehicle-delete', ['only' => ['destroy']]);

    $this->vehicleRepository = $vehicleRepository;
  }

  public function index()
  {
    $data = $this->vehicleRepository->allVehicles();
    $parentCategories = $data['categories'];
    $brands = $data['brands'];
    $models = $data['models'];
    return view('admin.vehicles.index', compact('parentCategories', 'brands', 'models'));
  }

  public function vehicleListAll(Request $request)
  {
    $filters = $request->only([
      'vehicle_parent_category_id',
      'vehicle_category_id',
      'vehicle_brand_id',
      'vehicle_model_id',
      'vehicle_color',
    ]);
    return $this->vehicleRepository->all($filters, true);
  }



}
